/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.IMSBlock;
import net.geforcemods.securitycraft.entity.IMSBomb;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class IMSBlockEntity
extends CustomizableBlockEntity
implements ITickable {
    private Option.IntOption range = new Option.IntOption(() -> ((IMSBlockEntity)this).func_174877_v(), "range", 15, 1, 30, 1);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private Option.TargetingModeOption targetingMode = new Option.TargetingModeOption(TargetingMode.PLAYERS_AND_MOBS);
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private int bombsRemaining = 4;
    private boolean updateBombCount = false;
    private int attackTime = this.getAttackInterval();

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.updateBombCount) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            int mineCount = (Integer)state.func_177229_b((IProperty)IMSBlock.MINES);
            if (mineCount != this.bombsRemaining) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)IMSBlock.MINES, (Comparable)Integer.valueOf(this.bombsRemaining)));
            }
            if (this.bombsRemaining < 4) {
                IItemHandler handler;
                TileEntity be = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
                if (be != null && (handler = (IItemHandler)be.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) != null) {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        if (handler.getStackInSlot(i).func_77973_b() != Item.func_150898_a((Block)SCContent.bouncingBetty)) continue;
                        handler.extractItem(i, 1, false);
                        ++this.bombsRemaining;
                        break;
                    }
                }
            } else {
                this.updateBombCount = false;
            }
        }
        if (!this.isDisabled() && this.attackTime-- == 0) {
            this.attackTime = this.getAttackInterval();
            this.launchMine();
        }
    }

    private void launchMine() {
        if (this.bombsRemaining > 0 && !this.field_145850_b.field_72995_K) {
            AxisAlignedBB area = BlockUtils.fromBounds(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1).func_72314_b((double)((Integer)this.range.get()).intValue(), (double)((Integer)this.range.get()).intValue(), (double)((Integer)this.range.get()).intValue());
            TargetingMode mode = this.getTargetingMode();
            this.field_145850_b.func_175647_a(EntityLivingBase.class, area, e -> {
                if (!(e instanceof EntityPlayer)) {
                    if (!(e instanceof EntityMob)) return false;
                }
                if (!mode.canAttackEntity((EntityLivingBase)e, this, this.respectInvisibility::isConsideredInvisible)) return false;
                return true;
            }).stream().findFirst().ifPresent(e -> {
                double addToX = this.bombsRemaining == 4 || this.bombsRemaining == 3 ? 0.84375 : 0.0;
                double addToZ = this.bombsRemaining == 4 || this.bombsRemaining == 2 ? 0.84375 : 0.0;
                int launchHeight = this.getLaunchHeight();
                double accelerationX = e.field_70165_t - (double)this.field_174879_c.func_177958_n();
                double accelerationY = e.func_174813_aQ().field_72338_b + (double)(e.field_70131_O / 2.0f) - (double)this.field_174879_c.func_177956_o() - (double)launchHeight;
                double accelerationZ = e.field_70161_v - (double)this.field_174879_c.func_177952_p();
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_72838_d((Entity)new IMSBomb(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + addToX, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + addToZ, accelerationX, accelerationY, accelerationZ, launchHeight, this));
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                --this.bombsRemaining;
                this.updateBombCount = true;
            });
        }
    }

    private int getLaunchHeight() {
        BlockPos upPos;
        IBlockState state;
        int height;
        for (height = 1; height <= 9 && (state = this.field_145850_b.func_180495_p(upPos = this.field_174879_c.func_177981_b(height))).func_177230_c().isAir(state, (IBlockAccess)this.field_145850_b, upPos); ++height) {
        }
        return height;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("bombsRemaining", this.bombsRemaining);
        tag.func_74757_a("updateBombCount", this.updateBombCount);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.bombsRemaining = tag.func_74762_e("bombsRemaining");
        this.updateBombCount = tag.func_74767_n("updateBombCount");
        if (tag.func_74764_b("targetingOption")) {
            this.targetingMode.setValue(TargetingMode.values()[tag.func_74762_e("targetingOption")]);
        }
    }

    public int getBombsRemaining() {
        return this.bombsRemaining;
    }

    public void setBombsRemaining(int bombsRemaining) {
        this.bombsRemaining = bombsRemaining;
    }

    public TargetingMode getTargetingMode() {
        return (TargetingMode)((Object)this.targetingMode.get());
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.SPEED};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range, this.disabled, this.ignoreOwner, this.targetingMode, this.respectInvisibility};
    }

    public int getAttackInterval() {
        return this.isModuleEnabled(ModuleType.SPEED) ? 40 : 80;
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }
}

